/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.SettingsModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TriggerSettingMessage
extends AbstractBuildingServerMessage<AbstractBuildingWorker> {
    private ResourceLocation key;
    private ISetting value;

    public TriggerSettingMessage() {
    }

    public TriggerSettingMessage(IBuildingView building, ISettingKey<?> key, ISetting value) {
        super(building);
        this.key = key.getUniqueId();
        this.value = value;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.key = buf.func_192575_l();
        this.value = (ISetting)StandardFactoryController.getInstance().deserialize(buf);
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_192572_a(this.key);
        StandardFactoryController.getInstance().serialize(buf, this.value);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuildingWorker building) {
        building.getFirstOptionalModuleOccurance(SettingsModule.class).ifPresent(m -> m.updateSetting(new SettingKey(this.value.getClass(), this.key), this.value, ctxIn.getSender()));
    }
}

